	subroutine vech(A,B,ndim,n,mdim,m,k,iopt,z)
c
c**********************************************************************
c
c   FORTRAN subroutine to calculate the stacking or half-stacking
c   vector of the product of two vectors.
c
c   Input: A = a double precision matrix of dimension n x m.
c          B = a double precision matrix of dimension m x k.
c          mdim = an integer containing the number of columns of A
c                 in the calling routine.
c          n = an integer containing the number of columns of A. 
c          mdim = an integer containing the number of columns of B
c                 in the calling routine.
c          m = an integer containing the number of rows of A and
c              the number of columns of B.
c          k = an integer containing the number of rows of B.
c          iopt = an integer indicating whether to take the half-
c                 stacking vector (iopt = 0) or the stacking vector
c                 (iopt = 1).
c
c   Output: z = a double precision vector containing the half-stacking
c               or stacking vector of A and B.  If iopt = 0, the 
c               length of y is (nk)[(nk)+1]/2.  If iopt = 1, the 
c               length of z is nk.
c
c   Accuracy: Implicit double precision.
c
c   Created: 7/19/97 Bonnie Ray
c   Modified: 7/23/97 Jane L. Harvill
c
c   Subprograms called: none.
c
c**********************************************************************
c
	parameter (nkmx = 5, npmx = 10)
	parameter (nqmx = (npmx*nkmx)**2)
c
	integer n,k,iopt,indexz
c
	double precision A(npmx*nkmx),B(1,npmx*nkmx)
	double precision z(nqmx)
c
c   Initialize z:
c
	do i = 1,nqmx
		z(i) = 0.0d0
	enddo
c
c   Calculate element by element product of the matrices A and B and
c   place result in vector z.
c
	llim = 1
	indexz = 0
c
     	do i = 1,k
	if(iopt.eq.0) llim = i
		do j = llim,n
			indexz = indexz + 1
			z(indexz)= A(j)*B(1,i)
 		enddo
	enddo
c
	return
	end
